//=============================================================================
// DZMutator.
//=============================================================================
class DZMutator expands Mutator;

var string TemplateString;
var class<Actor> DZClass[39];
var bool bExtraPawns;

function PostBeginPlay()
{
	local PlayerStart PS;

	ForEach AllActors( class'PlayerStart', PS )
	{
		TemplateString = String(Spawn(class'DZTemplate',,,PS.Location));

		break;
	}
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local int i;

	for ( i = 0; i < ArrayCount(DZClass); i++ )
	if ( ((Inventory(Other) != None) && Other.IsA(DZClass[i].Name)) || (Other.bIsPawn && (Other.Class == DZClass[i])) )
	{
		Other.SetPropertyText("DZSSPF",TemplateString);

		break;
	}

	if ( bExtraPawns && (ScriptedPawn(Other) != None) && (Pawn(Other).DropWhenKilled == None) )
	{
		if ( Other.Class == class'Behemoth' )
			Pawn(Other).DropWhenKilled = class'DZPSBrute';
		else if ( Other.Class == class'Brute' )
			Pawn(Other).DropWhenKilled = class'DZPSLesserBrute';
		else if ( Other.Class == class'Gasbag' )
			Pawn(Other).DropWhenKilled = class'DZPSManta';
		else if ( Other.Class == class'GiantGasbag' )
			Pawn(Other).DropWhenKilled = class'DZPSGasbag';
		else if ( Other.Class == class'GiantManta' )
		{
			if ( FRand() > 0.5 )
			Pawn(Other).DropWhenKilled = class'DZPSCaveManta';
			else
			Pawn(Other).DropWhenKilled = class'DZPSManta';
		}
		else if ( (Other.Class == class'Krall') || (Other.Class == class'KrallElite') )
		{
			if ( FRand() > 0.66 )
			Pawn(Other).DropWhenKilled = class'DZPSLeglessKrall';
			else if ( FRand() > 0.5 )
			Pawn(Other).DropWhenKilled = class'DZPSPowerPupae';
			else
			Pawn(Other).DropWhenKilled = class'DZPSPupae';
		}
		else if ( Other.Class == class'LesserBrute' )
		{
			if ( FRand() > 0.66 )
			Pawn(Other).DropWhenKilled = class'DZPSManta';
			else if ( FRand() > 0.5 )
			Pawn(Other).DropWhenKilled = class'DZPSPowerPupae';
			else
			Pawn(Other).DropWhenKilled = class'DZPSPupae';
		}
		else if ( Other.IsA('Mercenary') )
		{
			if ( FRand() > 0.66 )
			Pawn(Other).DropWhenKilled = class'DZPSManta';
			else if ( FRand() > 0.5 )
			Pawn(Other).DropWhenKilled = class'DZPSPowerPupae';
			else
			Pawn(Other).DropWhenKilled = class'DZPSPupae';
		}
		else if ( (Other.Class == class'Nali') || (Other.Class == class'NaliPriest') )
		{
			if ( FRand() > 0.66 )
			Pawn(Other).DropWhenKilled = class'DZPSLethalNaliChild';
			else if ( FRand() > 0.5 )
			Pawn(Other).DropWhenKilled = class'DZPSManta';
			else
			Pawn(Other).DropWhenKilled = class'DZPSPupae';
		}
		else if ( Other.IsA('Queen') )
		{
			if ( FRand() > 0.5 )
			Pawn(Other).DropWhenKilled = class'DZPSPowerPupae';
			else
			Pawn(Other).DropWhenKilled = class'DZPSPupae';
		}
		else if ( Other.IsA('Slith') )
		{
			if ( FRand() > 0.5 )
			Pawn(Other).DropWhenKilled = class'DZPSPowerPupae';
			else
			Pawn(Other).DropWhenKilled = class'DZPSPupae';
		}
		else if ( Other.IsA('Titan') )
			Pawn(Other).DropWhenKilled = class'DZPSWarlord';
		else if ( Other.Class == class'Warlord' )
		{
			if ( FRand() > 0.5 )
			Pawn(Other).DropWhenKilled = class'DZPSGasbag';
			else
			Pawn(Other).DropWhenKilled = class'DZPSManta';
		}
	}

	return True;
}

defaultproperties
{
     DZClass(0)=Class'BRStinger'
     DZClass(1)=Class'CMGESBioRifle'
     DZClass(2)=Class'CNStinger'
     DZClass(3)=Class'DZAmplifier'
     DZClass(4)=Class'DZDualDispersionPistol'
     DZClass(5)=Class'DZDualMag'
     DZClass(6)=Class'DZDynamite'
     DZClass(7)=Class'DZFlashlight'
     DZClass(8)=Class'DZInvisibility'
     DZClass(9)=Class'DZJumpBoots'
     DZClass(10)=Class'DZQuadShot'
     DZClass(11)=Class'DZSCUBAGear'
     DZClass(12)=Class'DZSearchLight'
     DZClass(13)=Class'DZSeeds'
     DZClass(14)=Class'DZShieldBelt'
     DZClass(15)=Class'DZSpeed'
     DZClass(16)=Class'DZStaticShieldBelt'
     DZClass(17)=Class'DZWeaponPowerUp'
     DZClass(18)=Class'FEShieldBelts'
     DZClass(19)=Class'FRStinger'
     DZClass(20)=Class'RJStinger'
     DZClass(21)=Class'LeglessKrall_'
     DZClass(22)=Class'LethalCow'
     DZClass(23)=Class'LethalCowCousin'
     DZClass(24)=Class'LethalNali'
     DZClass(25)=Class'LethalNaliChild'
     DZClass(26)=Class'LethalNaliCousin'
     DZClass(27)=Class'LethalTentacle'
     DZClass(28)=Class'LethalTentacleCarcass'
     DZClass(29)=Class'LightningBug'
     DZClass(30)=Class'NaliRabbit_'
     DZClass(31)=Class'PowerPupae'
     DZClass(32)=Class'PukeFly'
     DZClass(33)=Class'Pupae_'
     DZClass(34)=Class'Queen_'
     DZClass(35)=Class'Squid_'
     DZClass(36)=Class'Squider'
     DZClass(37)=Class'StoneTitan_'
     DZClass(38)=Class'Titan_'
     bExtraPawns=True
}
