//=============================================================================
// DZPawnSpawner.
//=============================================================================
class DZPawnSpawner expands Inventory abstract;

var class<Pawn> PawnClass;
var int Quantity, SpawnCount;

function BecomePickup();

auto state Pickup
{
	ignores Landed, Touch, ZoneChange;

	function BeginState()
	{
		if ( PawnClass != None )
		SetTimer(0.13,True);
		else
		Destroy();
	}

	function Timer()
	{
		local Pawn P;
		local int i;

		for ( i = 0; i < 25; i++ )
		{
			P = Spawn(PawnClass,,,Location+i*15*vect(0,0,4)+i*16*VRand(),Rotator(vect(1,1,0)*VRand()));

			if ( P != None )
			{
				P.Velocity = 280*VRand();
				P.SetPhysics(PHYS_Falling);

				SpawnCount++;

				break;
			}
		}

		if ( SpawnCount >= Quantity )
		Destroy();
	}
}

defaultproperties
{
     LifeSpan=10.000000
     bHidden=True
     RemoteRole=ROLE_None
     bCollideActors=False
     bCollideWorld=True
}
