//=============================================================================
// DZTemplate.
//=============================================================================
class DZTemplate expands DZSSFTemplate;

function A_PreBeginPlay(Actor DZActor)
{
	if ( DZActor.Class == class'DZQuadShot' )
	Inventory(DZActor).PickupViewMesh = mesh'QuadShotPickup';
	else if ( DZActor.Class == class'DZSpeed' )
	DZActor.SetPropertyText("spdfactor","3");
}

function A_PostBeginPlay(Actor DZActor)
{
	if ( DZActor.IsA('LethalCow') )
		Cow(DZActor).VoicePitch = 0.9+0.2*FRand();
	else if ( DZActor.IsA('LethalNali') )
	{
		if ( ScriptedPawn(DZActor).Orders == 'Ambushing' )
		DZActor.AnimSequence = 'Levitate';
	}
	else if ( DZActor.Class == class'LethalTentacle' )
		ScriptedPawn(DZActor).bLeadTarget = ScriptedPawn(DZActor).bLeadTarget && (FRand() > 0.5);
	else if ( DZActor.IsA('Pupae_') )
		Pawn(DZActor).MaxDesiredSpeed = 0.7+0.1*Pawn(DZActor).Skill;
	else if ( DZActor.Class == class'Queen_' )
	{
		ScriptedPawn(DZActor).ProjectileSpeed = 1200+100*Pawn(DZActor).Skill;
		Pawn(DZActor).GroundSpeed = Pawn(DZActor).GroundSpeed*(1+0.1*Pawn(DZActor).Skill);
	}
}

function P_damageAttitudeTo(ScriptedPawn DZPawn, Pawn Other)
{
	local eAttitude OldAttitude;

	if ( (Other == DZPawn) || (Other == None) || (FlockPawn(Other) != None) )
	return;

	if ( Other.bIsPlayer )
	{
		if ( DZPawn.IsA('LethalNali') )
			DZPawn.AttitudeToPlayer = ATTITUDE_Hate;
		else if ( (DZPawn.Health < 30) && (DZPawn.Aggressiveness*FRand() > 0.5) )
		{
			DZPawn.AttitudeToPlayer = ATTITUDE_Frenzy;
			DZPawn.Aggressiveness = 1;
		}
		else if ( DZPawn.AttitudeToPlayer == ATTITUDE_Ignore )
			DZPawn.AttitudeToPlayer = ATTITUDE_Hate;
		else if ( DZPawn.AttitudeToPlayer == ATTITUDE_Threaten )
			DZPawn.AttitudeToPlayer = ATTITUDE_Hate;
		else if ( DZPawn.AttitudeToPlayer == ATTITUDE_Friendly )
			DZPawn.AttitudeToPlayer = ATTITUDE_Threaten;
	}
	else
	{
		OldAttitude = DZPawn.AttitudeToCreature(Other);

		if ( OldAttitude > ATTITUDE_Ignore )
		return;
		else if ( OldAttitude > ATTITUDE_Frenzy )
		DZPawn.Hated = Other;
	}

	DZPawn.SetEnemy(Other);
}

function P_PreSetMovement(Pawn DZPawn)
{
	if ( DZPawn.JumpZ > 0 )
	DZPawn.bCanJump = True;

	DZPawn.bCanWalk = True;
	DZPawn.bCanSwim = False;
	DZPawn.bCanFly = False;
	DZPawn.MinHitWall = -0.6;

	if ( DZPawn.Intelligence > BRAINS_Reptile )
	DZPawn.bCanOpenDoors = True;

	if ( DZPawn.Intelligence == BRAINS_Human )
	DZPawn.bCanDoSpecial = True;

	if ( DZPawn.Class == class'LethalTentacle' )
	{
		DZPawn.bCanJump = False;
		DZPawn.bCanWalk = False;
		DZPawn.bCanSwim = True;
		DZPawn.bCanOpenDoors = False;
		DZPawn.bCanDoSpecial = False;
	}
	else if ( DZPawn.Class == class'LightningBug' )
	{
		DZPawn.bCanSwim = True;
		DZPawn.bCanFly = True;
		DZPawn.MaxDesiredSpeed = 0.6+0.13*DZPawn.Skill;
	}
	else if ( DZPawn.Class == class'PukeFly' )
	{
		DZPawn.bCanFly = True;
		DZPawn.bCanOpenDoors = False;
		DZPawn.bCanDoSpecial = False;
	}
	else if ( DZPawn.Class == class'Squid_' )
	{
		DZPawn.bCanWalk = False;
		DZPawn.bCanSwim = True;
		DZPawn.bCanOpenDoors = False;
		DZPawn.bCanDoSpecial = False;
		DZPawn.MaxDesiredSpeed = 0.7+0.1*DZPawn.Skill;
	}
	else if ( DZPawn.Class == class'Squider' )
	{
		DZPawn.bCanWalk = False;
		DZPawn.bCanSwim = True;
		DZPawn.bCanFly = True;
		DZPawn.bCanOpenDoors = False;
		DZPawn.bCanDoSpecial = False;
		DZPawn.MaxDesiredSpeed = 0.7+0.1*DZPawn.Skill;
	}
}

function P_SetMovementPhysics(Pawn DZPawn)
{
	if ( DZPawn.Class == class'LeglessKrall_' )
	{
		if ( DZPawn.Region.Zone.bWaterZone )
		DZPawn.SetPhysics(PHYS_Swimming);
		else if ( DZPawn.Physics != PHYS_Walking )
		DZPawn.SetPhysics(PHYS_Walking);
	}
	else if ( DZPawn.Class == class'LethalTentacle' )
	{
		if ( DZPawn.Region.Zone.bWaterZone )
		DZPawn.SetPhysics(PHYS_Swimming);
		else
		DZPawn.SetPhysics(PHYS_Rotating);
	}
	else if ( DZPawn.Class == class'LightningBug' )
	{
		if ( DZPawn.Region.Zone.bWaterZone )
		DZPawn.SetPhysics(PHYS_Swimming);
		else
		DZPawn.SetPhysics(PHYS_Flying);
	}
	else if ( DZPawn.Class == class'PukeFly' )
	{
		if ( DZPawn.Enemy != None )
		DZPawn.SetPhysics(PHYS_Flying);
		else if ( DZPawn.Physics != PHYS_Falling )
		DZPawn.SetPhysics(PHYS_Walking);
	}
	else if ( DZPawn.IsA('Pupae_') )
		DZPawn.SetPhysics(PHYS_Falling);
	else if ( DZPawn.Class == class'Squid_' )
	{
		if ( DZPawn.Region.Zone.bWaterZone )
			DZPawn.SetPhysics(PHYS_Swimming);
		else
		{
			DZPawn.SetPhysics(PHYS_Falling);
			DZPawn.MoveTimer = -1;
			DZPawn.GotoState('Flopping');
		}
	}
	else if ( DZPawn.Class == class'Squider' )
		DZPawn.SetPhysics(PHYS_Flying);
	else if ( DZPawn.Physics != PHYS_Falling )
		DZPawn.SetPhysics(PHYS_Walking);
}

function P_HearNoise(Pawn DZPawn, float Loudness, Actor NoiseMaker)
{
	if ( (ScriptedPawn(DZPawn) != None) && ScriptedPawn(DZPawn).SetEnemy(NoiseMaker.Instigator) )
	DZPawn.LastSeenPos = 0.5*(NoiseMaker.Location+VSize(NoiseMaker.Location-DZPawn.Location)*Vector(DZPawn.Rotation));
}

function P_SeePlayer(Pawn DZPawn, Actor Seen)
{
	if ( (ScriptedPawn(DZPawn) != None) && ScriptedPawn(DZPawn).SetEnemy(Pawn(Seen)) )
	DZPawn.LastSeenPos = DZPawn.Enemy.Location;
}

function eAttitude P_AttitudeTo(ScriptedPawn DZPawn, Pawn Other)
{
	if ( Other == None )
	return ATTITUDE_Ignore;

	if ( Other.bIsPlayer )
	{
		if ( (DZPawn.Intelligence > BRAINS_None) && ((DZPawn.AttitudeToPlayer == ATTITUDE_Hate) || (DZPawn.AttitudeToPlayer == ATTITUDE_Threaten) || (DZPawn.AttitudeToPlayer == ATTITUDE_Fear)) )
		{
			if ( DZPawn.RelativeStrength(Other) > DZPawn.Aggressiveness )
			DZPawn.AttitudeToPlayer = DZPawn.AttitudeWithFear();
			else if ( DZPawn.AttitudeToPlayer == ATTITUDE_Fear )
			DZPawn.AttitudeToPlayer = ATTITUDE_Hate;
		}

		return DZPawn.AttitudeToPlayer;
	}
	else if ( DZPawn.Hated == Other )
	{
		if ( DZPawn.RelativeStrength(Other) >= DZPawn.Aggressiveness )
		return DZPawn.AttitudeWithFear();
		else 
		return ATTITUDE_Hate;
	}
	else if ( (DZPawn.TeamTag != '') && (ScriptedPawn(Other) != None) && (DZPawn.TeamTag == ScriptedPawn(Other).TeamTag) )
		return ATTITUDE_Friendly;
	else
		return DZPawn.AttitudeToCreature(Other);
}

function eAttitude P_AttitudeToCreature(ScriptedPawn DZPawn, Pawn Other)
{
	if ( DZPawn.Class == class'LeglessKrall_' )
	{
		if ( Other.IsA('Krall') || Other.IsA('Pupae') || Other.IsA('Titan') )
		return ATTITUDE_Friendly;
		else if ( Other.IsA('Nali') )
		return ATTITUDE_Hate;
	}
	else if ( DZPawn.IsA('LethalCow') )
	{
		if ( Other.IsA('Cow') || Other.IsA('Nali') || Other.IsA('Tentacle') )
		return ATTITUDE_Friendly;
	}
	else if ( DZPawn.IsA('LethalNali') )
	{
		if ( Other.IsA('Nali') || Other.IsA('Cow') || Other.IsA('Tentacle') )
		return ATTITUDE_Friendly;
	}
	else if ( DZPawn.Class == class'LethalTentacle' )
	{
		if ( Other.IsA('Tentacle') || Other.IsA('Cow') || Other.IsA('Nali') )
		return ATTITUDE_Friendly;
		else if ( Other.IsA('ScriptedPawn') )
		return ATTITUDE_Hate;
	}
	else if ( DZPawn.Class == class'PukeFly' )
	{
		if ( Other.IsA('Fly') )
		return ATTITUDE_Friendly;
	}
	else if ( DZPawn.IsA('Pupae_') )
	{
		if ( Other.IsA('Pupae') || Other.IsA('Brute') || Other.IsA('Krall') || Other.IsA('Mercenary') || Other.IsA('Queen') || Other.IsA('Titan') || Other.IsA('Warlord') )
			return ATTITUDE_Friendly;
		else if ( Other.IsA('Skaarj') )
		{
			if ( Other.IsA('SkaarjBerserker') )
			return ATTITUDE_Ignore;
			else
			return ATTITUDE_Friendly;
		}
		else if ( Other.IsA('ScriptedPawn') )
			return ATTITUDE_Hate;
	}
	else if ( DZPawn.Class == class'Queen_' )
	{
		if ( Other.IsA('Queen') )
			return ATTITUDE_Friendly;
		else if ( Other.IsA('Skaarj') )
		{
			if ( Other.IsA('SkaarjBerserker') )
			return ATTITUDE_Hate;
			else
			return ATTITUDE_Friendly;
		}
		else if ( Other.IsA('Pupae') )
			return ATTITUDE_Friendly;
		else if ( Other.IsA('Nali') )
			return ATTITUDE_Hate;
	}
	else if ( DZPawn.IsA('Squid_') )
	{
		if ( Other.IsA('Squid') )
		return ATTITUDE_Friendly;
	}
	else if ( DZPawn.IsA('Titan') )
	{
		if ( Other.IsA('Titan') || Other.IsA('Krall') || Other.IsA('Pupae') || Other.IsA('Warlord') )
		return ATTITUDE_Friendly;
		else if ( Other.IsA('ScriptedPawn') )
		return ATTITUDE_Hate;
	}

	if ( Other.Class == DZPawn.Class )
	return ATTITUDE_Friendly;
	else
	return ATTITUDE_Ignore;
}

defaultproperties
{
     bHidden=True
     RemoteRole=ROLE_None
}
